package ru.yandex.webmaster3.storage.checklist.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class RealTimeSiteProblemInfo extends AbstractProblemInfo {
    private final DateTime lastFlushed;

    public RealTimeSiteProblemInfo(WebmasterHostId hostId, DateTime lastUpdate, DateTime actualSince, DateTime lastFlushed, SiteProblemState state,
                                   SiteProblemTypeEnum problemType, SiteProblemContent problemContent, int weight) {
        super(hostId, problemContent, problemType, actualSince, state, lastUpdate, weight);
        this.lastFlushed = lastFlushed;
    }

    public DateTime getLastFlushed() {
        return lastFlushed;
    }

    public RealTimeSiteProblemInfo withContent(SiteProblemContent problemContent, DateTime lastUpdate) {
        return new RealTimeSiteProblemInfo(getHostId(), lastUpdate, getActualSince(), getLastFlushed(), getState(),
                getProblemType(), problemContent, getWeight());
    }

    public RealTimeSiteProblemInfo withLastUpdate(DateTime lastUpdate) {
        return new RealTimeSiteProblemInfo(getHostId(), lastUpdate, getActualSince(), getLastFlushed(), getState(),
                getProblemType(), getContent(), getWeight());
    }

    public RealTimeSiteProblemInfo withNewState(SiteProblemState state, DateTime actualSince, DateTime lastFlushed, DateTime lastUpdate) {
        return new RealTimeSiteProblemInfo(getHostId(), lastUpdate, actualSince, lastFlushed, state,
                getProblemType(), getContent(), getWeight());
    }
}
