package ru.yandex.webmaster3.storage.checklist.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class RecentlySentProblemNotification {
    private final WebmasterHostId hostId;
    private final SiteProblemTypeEnum problemType;
    private final SiteProblemState problemState;
    private final DateTime date;

    public RecentlySentProblemNotification(WebmasterHostId hostId, SiteProblemTypeEnum problemType, SiteProblemState problemState, DateTime date) {
        this.hostId = hostId;
        this.problemType = problemType;
        this.problemState = problemState;
        this.date = date;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public SiteProblemTypeEnum getProblemType() {
        return problemType;
    }

    public SiteProblemState getProblemState() {
        return problemState;
    }

    public DateTime getDate() {
        return date;
    }
}
