package ru.yandex.webmaster3.storage.checklist.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class SiteProblemHistoryRecord {
    private final WebmasterHostId hostId;
    private final DateTime date;
    private final SiteProblemTypeEnum problemType;
    private final boolean fixed;
    private final int weight;

    public SiteProblemHistoryRecord(WebmasterHostId hostId, DateTime date, SiteProblemTypeEnum problemType, boolean fixed, int weight) {
        this.hostId = hostId;
        this.date = date;
        this.problemType = problemType;
        this.fixed = fixed;
        this.weight = weight;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public DateTime getDate() {
        return date;
    }

    public SiteProblemTypeEnum getProblemType() {
        return problemType;
    }

    public boolean isFixed() {
        return fixed;
    }

    public int getWeight() {
        return weight;
    }
}
