package ru.yandex.webmaster3.storage.checklist.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class SiteProblemInfo extends AbstractProblemInfo {
    private final UUID generationId;
    private final DateTime lastFlushed;

    public SiteProblemInfo(WebmasterHostId hostId, UUID generationId, DateTime actualSince, DateTime lastFlushed, DateTime lastUpdate,
                           SiteProblemState state, int weight, SiteProblemTypeEnum problemType, SiteProblemContent content) {
        super(hostId, content, problemType, actualSince, state, lastUpdate, weight);
        this.generationId = generationId;
        this.lastFlushed = lastFlushed;
    }

    public UUID getGenerationId() {
        return generationId;
    }

    public DateTime getLastFlushed() {
        return lastFlushed;
    }

    public static SiteProblemInfo fromProblemSignal(ProblemSignal signal, WebmasterHostId hostId, UUID generationId,
                                                    DateTime actualSince, DateTime lastFlushed, int weight) {
        return new SiteProblemInfo(hostId, generationId, actualSince, lastFlushed, signal.getLastUpdate(), signal.getState(), weight,
                signal.getProblemType(), signal.getContent());
    }
}
