package ru.yandex.webmaster3.storage.checklist.data;

import lombok.Data;
import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
@Data
@RequiredArgsConstructor
public class SiteProblemRecheckInfo {
    private static final Duration PROBLEM_RECHECK_SLA = Duration.standardDays(14);

    private final WebmasterHostId hostId;
    private final SiteProblemTypeEnum problemType;
    private final boolean recheckRequested;
    private final boolean recheckFailed;
    private final DateTime requestDate;

    public boolean isExpired() {
        return requestDate != null && requestDate.plus(PROBLEM_RECHECK_SLA).isBefore(DateTime.now());
    }

    public RecheckState getState(DateTime problemLastUpdateTime) {
        boolean isProblemChanged = (problemLastUpdateTime != null && problemLastUpdateTime.isAfter(requestDate));
        if (isProblemChanged) {
            return new RecheckState(false, false);
        }

        if (isExpired()) {
            return new RecheckState(false, true);
        }

        return new RecheckState(recheckRequested && !recheckFailed, recheckFailed);
    }

    @Data
    public static class RecheckState {
        public final boolean isInProgres;
        public final boolean isFailed;
    }
}
