package ru.yandex.webmaster3.storage.checklist.data;

import org.joda.time.LocalDate;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SiteProblemsHistoryPoint {
    private final LocalDate date;
    private final int health;
    private final List<WeightedProblemStateChange> problemChanges;
    private final boolean haveFatalProblems;

    public SiteProblemsHistoryPoint(LocalDate date, int health, List<WeightedProblemStateChange> problemChanges, boolean haveFatalProblems) {
        this.date = date;
        this.health = health;
        this.problemChanges = problemChanges;
        this.haveFatalProblems = haveFatalProblems;
    }

    @Description("значение показателя живости за указанную дату")
    public int getHealth() {
        return health;
    }

    public LocalDate getDate() {
        return date;
    }

    @Description("изменения в списке проблем, произошедшие в указанную дату")
    public List<WeightedProblemStateChange> getProblemChanges() {
        return problemChanges;
    }

    @Description("присутствуют ли фатальные проблемы на указанную дату")
    public boolean isHaveFatalProblems() {
        return haveFatalProblems;
    }

    public static class WeightedProblemStateChange {
        private final SiteProblemTypeEnum problemType;
        private final int weight;
        private final ProblemEventType event;

        public WeightedProblemStateChange(SiteProblemTypeEnum problemType, int weight, ProblemEventType event) {
            this.problemType = problemType;
            this.weight = weight;
            this.event = event;
        }

        public SiteProblemTypeEnum getProblemType() {
            return problemType;
        }

        public int getWeight() {
            return weight;
        }

        @Description("что произошло - проблема появилась/исчезла в этот день")
        public ProblemEventType getEvent() {
            return event;
        }
    }

    public enum ProblemEventType{
        APPEAR,
        DISAPPEAR
    }
}
