package ru.yandex.webmaster3.storage.checklist.data;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Getter;
import lombok.ToString;

/**
 * @author: ishalaru
 * DATE: 15.07.2019
 */
@Getter
@ToString
public class TurboHostBanSample {

    public static final TypeReference<List<TurboHostBanSample>> LIST_REFERENCE = new TypeReference<>() {
    };

    private final String frozenUrl;
    private final String prodUrl;
    private final String originalUrl;
    private final List<String> reasons;
    private final int weight;

    @JsonCreator
    public TurboHostBanSample(@JsonProperty("frozenUrl") String frozenUrl,
                              @JsonProperty("prodUrl") String prodUrl,
                              @JsonProperty("originalUrl") String originalUrl,
                              @JsonProperty("reasons") List<String> reasons,
                              @JsonProperty("weight") int weight) {
        this.frozenUrl = frozenUrl;
        this.prodUrl = prodUrl;
        this.originalUrl = originalUrl;
        this.reasons = reasons;
        this.weight = weight;
    }
}
