package ru.yandex.webmaster3.storage.checklist.data.problems;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.checklist.data.NotMobileFriendlyStatus;
import ru.yandex.webmaster3.core.checklist.data.MobileUrlCheckStatus;

import java.net.URL;

/**
 * @author avhaliullin
 */
@Getter
@AllArgsConstructor
public class MobileUrlSample {
    @JsonProperty("sampleType")
    private final NotMobileFriendlyStatus sampleType;
    @JsonProperty("url")
    private final URL url;
    @Description("цель редиректа")
    @JsonProperty("target")
    private final URL target;
    @Description("альтернативный url - присутствует для проблемы NO_MOBILE_FROM_DESKTOP")
    @JsonProperty("alternate")
    private final URL alternate;
    @Description("url, который мы ожидаем увидеть для мобильной версии - присутствует для проблемы NO_MOBILE_FROM_DESKTOP")
    @JsonProperty("expectedUrl")
    private final URL expectedUrl;
    @Description("статус мобилопригодности для урла, получаемый от робота")
    @JsonProperty("mobileProblem")
    private final MobileUrlCheckStatus mobileProblem;
}
