package ru.yandex.webmaster3.storage.checklist.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.mobile.HostMobileAuditService;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

/**
 * @author avhaliullin
 */
@Component
@Slf4j
public class HostMobileProblemsRechecker implements ProblemRechecker {
    private final HostMobileAuditService hostMobileAuditService;

    @Autowired
    public HostMobileProblemsRechecker(
            HostMobileAuditService hostMobileAuditService) {
        this.hostMobileAuditService = hostMobileAuditService;
    }

    @Override
    public void recheck(WebmasterHostId hostId, SiteProblemTypeEnum problemType) {
        try {
            hostMobileAuditService.recheck(hostId);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to add host to mobile audit queue",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }
}
