package ru.yandex.webmaster3.storage.checklist.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.client.WorkerClient;
import ru.yandex.webmaster3.core.worker.task.Test404ErrorsAbsenceTaskData;

/**
 * @author avhaliullin
 */
@Component("no404ErrorsRechecker")
public class No404ErrorsRechecker implements ProblemRechecker {
    final private WorkerClient workerClient;

    @Autowired
    public No404ErrorsRechecker(@Qualifier("lbWorkerClient") WorkerClient workerClient) {
        this.workerClient = workerClient;
    }

    @Override
    public void recheck(WebmasterHostId hostId, SiteProblemTypeEnum problemType) {
        workerClient.enqueueTask(new Test404ErrorsAbsenceTaskData(hostId));
    }

}
