package ru.yandex.webmaster3.storage.checklist.service;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemStorageType;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.service.HostOwnerService;
import ru.yandex.webmaster3.core.metrika.counters.MetrikaCountersUtil;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.util.WwwUtil;

/**
 * Created by Oleg Bazdyrev on 07/08/2020.
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class SiteProblemStorageService {

    private final HostOwnerService hostOwnerService;

    public WebmasterHostId toProblemHostId(WebmasterHostId hostId, SiteProblemStorageType storageType) {
        switch (storageType) {
            case REAL_TIME_DOMAIN:
            case TURBO_PROBLEM:
                return IdUtils.urlToHostId(WwwUtil.cutWWWAndM(hostId));
            case REAL_TIME_DOMAIN_WITH_M:
                return IdUtils.urlToHostId(MetrikaCountersUtil.hostToPunycodeDomain(hostId));
            case REAL_TIME_OWNER:
                return hostOwnerService.getHostOwner(hostId);
            default:
                return hostId;
        }
    }

    public WebmasterHostId toProblemHostId(WebmasterHostId hostId, SiteProblemTypeEnum problemType){
        return toProblemHostId(hostId,problemType.getStorageType());
    }

}
