package ru.yandex.webmaster3.storage.checklist.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import com.google.common.collect.Maps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostGeneration;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.checklist.data.AbstractProblemInfo;

/**
 * Created by Oleg Bazdyrev on 26/12/2019.
 */
public interface SiteProblemsProvider {

    /**
     * Получение списка проблем хоста
     * @param hostId
     * @param generationId
     * @return
     */
    @NotNull List<? extends AbstractProblemInfo> listProblems(@NotNull WebmasterHostId hostId, @Nullable UUID generationId);

    default List<? extends AbstractProblemInfo> listProblems(WebmasterHostId hostId) {
        return listProblems(hostId, null);
    }

    default Map<WebmasterHostId, List<? extends AbstractProblemInfo>> listProblems(List<WebmasterHostGeneration> hosts) {
        return hosts.stream()
                .map(hostGeneration -> {
                    var hostProblems = listProblems(hostGeneration.getHostId(), hostGeneration.getGenerationId());
                    return Maps.immutableEntry(hostGeneration.getHostId(), hostProblems);
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default AbstractProblemInfo getProblem(@NotNull WebmasterHostId hostId, @Nullable UUID generationId, @NotNull SiteProblemTypeEnum problemType) {
        return listProblems(hostId, generationId).stream().filter(problem -> problem.getProblemType() == problemType).findAny().orElse(null);
    }

    /**
     * Какие типы проблем данный провайдер поддерживает
     * @return
     */
    @NotNull Set<SiteProblemTypeEnum> getSupportedProblemTypes();

}
