package ru.yandex.webmaster3.storage.checklist.service;

import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.sitemap.dao.ForceSitemapExportQueueYDao;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class SitemapForceExportRechecker implements ProblemRechecker {

    private final ForceSitemapExportQueueYDao forceSitemapExportQueueYDao;

    @Override
    public void recheck(WebmasterHostId hostId, SiteProblemTypeEnum problemType) {
        forceSitemapExportQueueYDao.addRecord(hostId, DateTime.now());
    }
}
