package ru.yandex.webmaster3.storage.checklist.service;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.checklist.dao.TurboHostBanRecheckQueueYDao;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

/**
 * Created by Oleg Bazdyrev on 19/11/2018.
 */
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class TurboHostBanRechecker implements ProblemRechecker {

    private final TurboHostBanRecheckQueueYDao turboHostBanRecheckQueueYDao;

    @Override
    public void recheck(WebmasterHostId hostId, SiteProblemTypeEnum problemType) {
        try {
            Preconditions.checkArgument(problemType == SiteProblemTypeEnum.TURBO_HOST_BAN || problemType == SiteProblemTypeEnum.TURBO_HOST_BAN_INFO);
            turboHostBanRecheckQueueYDao.addRecord(hostId);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Error writing to recheck queue",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }
}
