package ru.yandex.webmaster3.storage.checklist.service;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.checklist.dao.TurboInvalidCartUrlRecheckQueueYDao;

/**
 * Created by Oleg Bazdyrev on 29/06/2020.
 */
@Slf4j
@Component("turboInvalidCartUrlRechecker")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class TurboInvalidCartUrlRechecker implements ProblemRechecker {

    private final TurboInvalidCartUrlRecheckQueueYDao turboInvalidCartUrlRecheckQueueYDao;

    @Override
    public void recheck(WebmasterHostId hostId, SiteProblemTypeEnum problemType) {
        Preconditions.checkState(problemType == SiteProblemTypeEnum.TURBO_INVALID_CART_URL);
        turboInvalidCartUrlRecheckQueueYDao.addRecord(WwwUtil.cutWWWAndM(hostId));
    }
}
