package ru.yandex.webmaster3.storage.checklist.service;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.checklist.dao.YaBrowserBadAdRecheckQueueYDao;
import ru.yandex.webmaster3.storage.checklist.data.AbstractProblemInfo;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

/**
 * Created by Oleg Bazdyrev on 01/12/2017.
 */
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class YaBrowserBadAdsRechecker implements ProblemRechecker {

    private final SiteProblemsService siteProblemsService;
    private final YaBrowserBadAdRecheckQueueYDao yaBrowserBadAdRecheckQueueYDao;

    @Override
    public void recheck(WebmasterHostId hostId, SiteProblemTypeEnum problemType) {
        try {
            Preconditions.checkArgument(problemType == SiteProblemTypeEnum.YABROWSER_BADAD);
            AbstractProblemInfo problemInfo = siteProblemsService.getRealTimeProblemInfo(hostId, problemType);
            SiteProblemContent.YaBrowserBadAd content = (SiteProblemContent.YaBrowserBadAd) problemInfo.getContent();
            yaBrowserBadAdRecheckQueueYDao.addRecord(hostId, content.getFormats());
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Error writing to recheck queue",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass() , e), e);
        }
    }
}
