package ru.yandex.webmaster3.storage.checklist.util;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;

import java.util.Arrays;

/**
 * @author avhaliullin
 */
public class SiteProblemWeightUtil {
    public static final int TOTAL_PROBLEMS_WEIGHT;

    static {
        TOTAL_PROBLEMS_WEIGHT = Arrays.stream(SiteProblemTypeEnum.values()).map(SiteProblemTypeEnum::getSeverity)
                .mapToInt(SiteProblemSeverityEnum::getWeight).sum();
    }

    public static int computeWeight(SiteProblemTypeEnum problemType) {
        return problemType.getSeverity().getWeight();
    }
}
