package ru.yandex.webmaster3.storage.clickhouse;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.FNVHash;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

/**
 * @author aherman
 */
public interface ClickhouseTable extends LocalClickhouseTableProvider {

    TableType getType();

    DateTime getUpdateDate();

    String getClickhouseFullName();

    String getDistributedTableName();

    String getLocalTableName();

    /**
     * На какое количество шардов разбита таблица
     * @return
     */
    int getShardCount();

    /**
     * На какое количество кусочков разбита таблица
     * @return
     */
    int getPartCount();

    default int getShardCountOrDefault(ClickhouseServer clickhouseServer) {
        int result = getShardCount();
        return result == 0 ? clickhouseServer.getShardsCount() : result;
    }

    default int getPartCountOrDefault() {
        int result = getPartCount();
        return result == 0 ? 1 : result;
    }

    @Override
    default String getTableName() {
        return getLocalTableName();
    }

    default int getHash(ClickhouseServer clickhouseServer, Object key) {
        int tablesCount = getShardCountOrDefault(clickhouseServer) * getPartCountOrDefault();
        return (int) (FNVHash.hash64Mod(key.toString(), tablesCount));
    }

    @Override
    default int getShard(ClickhouseServer clickhouseServer, Object key) {
        return getHash(clickhouseServer, key) / getPartCountOrDefault();
    }

    /**
     * Возвращает актуальное имя таблица с учетом партицинирования
     */
    @Override
    default String getTableName(ClickhouseServer clickhouseServer, WebmasterHostId key) {
        return getClickhouseFullName();
    }

    @Override
    default String getDistrTableName() {
        return getDistributedTableName();
    }
}
