package ru.yandex.webmaster3.storage.clickhouse;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.CityHash102;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseException;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseHost;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseHostLocation;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseQueryContext;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

/**
 * Created by Oleg Bazdyrev on 22/01/2021.
 * Для выбора таблицы на конкретном кликхаусе
 */
public interface LocalClickhouseTableProvider {

    default String getTableName() {
        return getTableName(null, null);
    }

    String getDistrTableName();

    /**
     * Получение названия локальной таблицы (с БД)
     * @return
     */
    String getTableName(ClickhouseServer clickhouseServer, WebmasterHostId key);

    /**
     * Получение шарда по ключу шардирования
     * @param key
     * @return
     */
    int getShard(ClickhouseServer clickhouseServer, Object key);

    /**
     * Получение контекста по ключу шардирования
     * @param clickhouseServer
     * @param key
     * @return
     */
    default ClickhouseQueryContext.Builder chContext(ClickhouseServer clickhouseServer, Object key) {
        int shard = getShard(clickhouseServer, key);
        List<ClickhouseHost> aliveHosts = clickhouseServer.getHosts().stream().filter(ClickhouseHost::isUp)
                .filter(host -> host.getShard() == shard).collect(Collectors.toList());
        if (aliveHosts.isEmpty()) {
            throw new ClickhouseException("Not found alive host for shard " + shard, null, null);
        }
        // choose random DC, but prefer same
        int dc = (int) Long.remainderUnsigned(CityHash102.cityHash64(String.valueOf(key)), aliveHosts.size());
        return ClickhouseQueryContext.useDefaults().setHost(aliveHosts.get(dc));
    }
}
