package ru.yandex.webmaster3.storage.clickhouse;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum TableState implements IntEnum {
    UNKNOWN(    0),

    IMPORTING(  10),
    IMPORTED(   11),
    DEPLOYING(  20),
    DEPLOYED(   21),
    PRE_ONLINE( 30),
    ON_LINE(    31),
    ARCHIVED(   40),
    FAILED(     100),
    ;

    TableState(int value) {
        this.value = value;
    }

    private final int value;

    @Override
    public int value() {
        return value;
    }

    public boolean isOnline() {
        return this == ON_LINE || this == PRE_ONLINE;
    }

    public static IntEnumResolver<TableState> R = IntEnumResolver.r(TableState.class);
}
