package ru.yandex.webmaster3.storage.clickhouse.replication.data;

import java.util.List;
import java.util.UUID;

import com.datastax.driver.core.utils.UUIDs;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.type.TypeReference;
import org.joda.time.DateTime;

/**
 * @author avhaliullin
 */
public class ClickhouseReplicationCommand {
    private final UUID replicationTaskId;
    private final String database;
    private final ClickhouseReplicationPriority priority;
    private final List<TableInfo> tables;

    public ClickhouseReplicationCommand(UUID replicationTaskId, String database, ClickhouseReplicationPriority priority, List<TableInfo> tables) {
        this.replicationTaskId = replicationTaskId;
        this.database = database;
        this.priority = priority;
        this.tables = tables;
    }

    public UUID getReplicationTaskId() {
        return replicationTaskId;
    }

    public DateTime getCreateDate() {
        return new DateTime(UUIDs.unixTimestamp(replicationTaskId));
    }

    public String getDatabase() {
        return database;
    }

    public ClickhouseReplicationPriority getPriority() {
        return priority;
    }

    public List<TableInfo> getTables() {
        return tables;
    }

    @Override
    public String toString() {
        return "ClickhouseReplicationCommand{" +
                "replicationTaskId=" + replicationTaskId +
                ", database='" + database + '\'' +
                ", priority=" + priority +
                ", tables=" + tables +
                '}';
    }

    public static class TableInfo {
        public static final TypeReference<List<TableInfo>> LIST_REFERENCE = new TypeReference<>() {
        };
        private final String name;
        private final String createSpec;
        private final int shard;

        @JsonCreator
        public TableInfo(String name, String createSpec, int shard) {
            this.name = name;
            this.createSpec = createSpec;
            this.shard = shard;
        }

        public String getName() {
            return name;
        }

        public String getCreateSpec() {
            return createSpec;
        }

        public int getShard() {
            return shard;
        }

        @Override
        public String toString() {
            return "TableInfo{" +
                    "name='" + name + '\'' +
                    ", shard=" + shard +
                    '}';
        }
    }
}
