package ru.yandex.webmaster3.storage.clickhouse.replication.data;

import java.util.Comparator;

import lombok.ToString;

/**
 * @author avhaliullin
 */
@ToString
public class ClickhouseReplicationTaskGroup {
    private final ClickhouseReplicationCommand command;
    private final ClickhouseReplicationState state;

    public ClickhouseReplicationTaskGroup(ClickhouseReplicationCommand command, ClickhouseReplicationState state) {
        this.command = command;
        this.state = state;
    }

    public ClickhouseReplicationCommand getCommand() {
        return command;
    }

    public ClickhouseReplicationState getState() {
        return state;
    }

    public ClickhouseReplicationTaskGroup finished() {
        return new ClickhouseReplicationTaskGroup(command, ClickhouseReplicationState.DONE);
    }

    public ClickhouseReplicationTaskGroup started() {
        return new ClickhouseReplicationTaskGroup(command, ClickhouseReplicationState.IN_PROGRESS);
    }

    public static final Comparator<ClickhouseReplicationTaskGroup> BY_PRIORITY_AND_DATE =
            Comparator.<ClickhouseReplicationTaskGroup>comparingInt(taskGroup -> taskGroup.getCommand().getPriority().ordinal())
                    .thenComparing(taskGroup -> taskGroup.getCommand().getCreateDate());
}
