package ru.yandex.webmaster3.storage.clickhouse.system.data;

/**
 * Class for storing content of clickhouse system table system.replicas
 * Created by Oleg Bazdyrev on 31/05/2017.
 */
public class ClickhouseSystemReplicaInfo {

    private final String database;
    private final String table;
    private final String engine;
    private final boolean isLeader;
    private final String zookeeperPath;
    private final String replicaName;
    private final String replicaPath;
    private final int columnsVersion;
    private final int insertsInQueue;
    private final int mergesInQueue;
    private final int totalReplicas;
    private final int activeReplicas;

    public ClickhouseSystemReplicaInfo(String database, String table, String engine, boolean isLeader,
                                       String zookeeperPath, String replicaName, String replicaPath,
                                       int columnsVersion, int insertsInQueue, int mergesInQueue, int totalReplicas,
                                       int activeReplicas) {
        this.database = database;
        this.table = table;
        this.engine = engine;
        this.isLeader = isLeader;
        this.zookeeperPath = zookeeperPath;
        this.replicaName = replicaName;
        this.replicaPath = replicaPath;
        this.columnsVersion = columnsVersion;
        this.insertsInQueue = insertsInQueue;
        this.mergesInQueue = mergesInQueue;
        this.totalReplicas = totalReplicas;
        this.activeReplicas = activeReplicas;
    }

    public String getDatabase() {
        return database;
    }

    public String getTable() {
        return table;
    }

    public String getEngine() {
        return engine;
    }

    public boolean isLeader() {
        return isLeader;
    }

    public String getZookeeperPath() {
        return zookeeperPath;
    }

    public String getReplicaName() {
        return replicaName;
    }

    public String getReplicaPath() {
        return replicaPath;
    }

    public int getColumnsVersion() {
        return columnsVersion;
    }

    public int getInsertsInQueue() {
        return insertsInQueue;
    }

    public int getMergesInQueue() {
        return mergesInQueue;
    }

    public int getTotalReplicas() {
        return totalReplicas;
    }

    public int getActiveReplicas() {
        return activeReplicas;
    }
}
