package ru.yandex.webmaster3.storage.clickhouse.table;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTable;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTableWrapper;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

/**
 * @author aherman
 */
public class ExternalLinkSamplesTable extends ClickhouseTableWrapper {

    public ExternalLinkSamplesTable(ClickhouseTable parent) {
        super(parent);
    }

    @Override
    public String getTableName(ClickhouseServer clickhouseServer, WebmasterHostId hostId) {
        if (getPartCount() == 0)
            return super.getTableName(clickhouseServer, hostId);
        return getClickhouseFullName().replace("_distrib", "_shard_" + (getHash(clickhouseServer, hostId) % getPartCount()));
    }
}
