package ru.yandex.webmaster3.storage.clickhouse.table;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTable;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTableWrapper;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

/**
 * @author aherman
 */
public class QueriesWeekSmallTable extends ClickhouseTableWrapper {

    // временный костыль для использования старых таблиц
    private static final int PARTS_COUNT = 8;

    public QueriesWeekSmallTable(ClickhouseTable parent) {
        super(parent);
    }

    @Override
    public int getPartCountOrDefault() {
        int result = getPartCount();
        return result == 0 ? PARTS_COUNT : result;
    }

    /**
     * Возвращает актуальное имя таблица с учетом партицинирования
     */
    @Override
    public String getTableName(ClickhouseServer clickhouseServer, WebmasterHostId hostId) {
        return getClickhouseFullName().replace("_distrib", "_part_" + (getHash(clickhouseServer, hostId) % getPartCountOrDefault()));
    }
}