package ru.yandex.webmaster3.storage.clickhouse.table;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTableWrapper;
import ru.yandex.webmaster3.storage.searchurl.offline.dao.SearchBaseImportedTable;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

/**
 * Created by ifilippov5 on 15.05.17.
 */
public class SearchUrlsTable extends ClickhouseTableWrapper {
    private static final int PARTS_COUNT = 8;

    public SearchUrlsTable(SearchBaseImportedTable parent) {
        super(parent);
    }

    public int getPartCountOrDefault() {
        int result = getPartCount();
        return result == 0 ? PARTS_COUNT : result;
    }

    /**
     * distributed -> merge -> local
     * {table_name} -> {table_name}_shard -> {table_name}_part{part}
     */
    public String getFullTableName(ClickhouseServer clickhouseServer, WebmasterHostId hostId) {
        return getClickhouseFullName() + "_part" + getHash(clickhouseServer, hostId) % getPartCountOrDefault();
    }
}
