package ru.yandex.webmaster3.storage.clickhouse.table;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTable;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTableWrapper;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

/**
 * @author aherman
 */
public class Top3000QueriesTable extends ClickhouseTableWrapper {

    private final String partSuffix; // TODO убить костыль

    public Top3000QueriesTable(ClickhouseTable parent) {
        this(parent, "_shard_");
    }

    public Top3000QueriesTable(ClickhouseTable parent, String partSuffix) {
        super(parent);
        this.partSuffix = partSuffix;
    }

    /**
     * Возвращает актуальное имя таблица с учетом партицинирования
     */
    @Override
    public String getTableName(ClickhouseServer clickhouseServer, WebmasterHostId hostId) {
        String suffix = getPartCount() == 1 ? "" : partSuffix + (getHash(clickhouseServer, hostId) % getPartCount());
        return getClickhouseFullName().replace("_distrib", suffix);
    }

}