package ru.yandex.webmaster3.storage.clickhouse.table;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTable;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTableInfo;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTableWrapper;
import ru.yandex.webmaster3.storage.clickhouse.TableType;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

/**
 * @author aherman
 */
public class Top3000ValuesTable extends ClickhouseTableWrapper {

    // временный костыль для использования старых таблиц
    private static final int PARTS_COUNT = 8;

    private final String partSuffix; // TODO убить костыль

    public Top3000ValuesTable(ClickhouseTable parent) {
        this(parent, "_shard_");
    }

    public Top3000ValuesTable(ClickhouseTable parent, String partSuffix) {
        super(parent);
        this.partSuffix = partSuffix;
    }

    @Override
    public int getPartCountOrDefault() {
        int result = getPartCount();
        return result == 0 ? PARTS_COUNT : result;
    }

    /**
     * Возвращает актуальное имя таблица с учетом партицинирования
     */
    @Override
    public String getTableName(ClickhouseServer clickhouseServer, WebmasterHostId hostId) {
        return getClickhouseFullName().replace("_distrib", partSuffix + (getHash(clickhouseServer, hostId) % getPartCountOrDefault()));
    }
}