package ru.yandex.webmaster3.storage.clickhouse.table;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTable;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTableWrapper;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

/**
 * @author lester
 */
public class TopUrlsTextsTable extends ClickhouseTableWrapper {

    private final String partSuffix; // TODO убить костыль

    public TopUrlsTextsTable(ClickhouseTable parent) {
        this(parent, "_shard_");
    }

    public TopUrlsTextsTable(ClickhouseTable parent, String partSuffix) {
        super(parent);
        this.partSuffix = partSuffix;
    }

    /**
     * Возвращает актуальное имя таблица с учетом партицинирования
     */
    @Override
    public String getTableName(ClickhouseServer clickhouseServer, WebmasterHostId hostId) {
        String suffix = getPartCount() == 1 ? "" : partSuffix + (getHash(clickhouseServer, hostId) % getPartCount());
        return getClickhouseFullName().replace("_distrib", suffix);
    }

}