package ru.yandex.webmaster3.storage.crawl;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author leonidrom
 */
public record RotorSettings(WebmasterHostId hostId, RenderSettings renderSettings) {
    public enum RenderSettings {
        RENDER_ON,
        RENDER_OFF,
        RENDER_AUTO,
        ;

        public static EnumResolver<RenderSettings> R = EnumResolver.er(RenderSettings.class);
    }
}
