package ru.yandex.webmaster3.storage.delegation;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author leonidrom
 */
public abstract class AnonymousHostDelegationRecord {
    protected final DateTime delegatedDate;
    protected final WebmasterHostId hostId;
    protected final boolean cancelled;
    protected final DateTime cancelledDate;

    public AnonymousHostDelegationRecord(DateTime delegatedDate, WebmasterHostId hostId,
                                         boolean cancelled, DateTime cancelledDate) {
        this.delegatedDate = delegatedDate;
        this.hostId = hostId;
        this.cancelled = cancelled;
        this.cancelledDate = cancelledDate;
    }

    public DateTime getDelegatedDate() {
        return delegatedDate;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    public DateTime getCancelledDate() {
        return cancelledDate;
    }
}
