package ru.yandex.webmaster3.storage.delegation;

import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class HostDelegationRecord extends AnonymousHostDelegationRecord {
    private final long fromUser;
    private final long toUser;
    private final Long cancelledByUser;

    public HostDelegationRecord(long fromUser, long toUser, WebmasterHostId hostId, DateTime delegatedDate,
                                boolean cancelled, DateTime cancelledDate, @Nullable Long cancelledByUser) {
        super(delegatedDate, hostId, cancelled, cancelledDate);
        this.fromUser = fromUser;
        this.toUser = toUser;
        this.cancelledByUser = cancelledByUser;
    }

    public long getFromUser() {
        return fromUser;
    }

    public long getToUser() {
        return toUser;
    }

    @Nullable
    public Long getCancelledByUser() {
        return cancelledByUser;
    }

    public HostDelegationRecord copyCancelled(long byUserId) {
        return new HostDelegationRecord(fromUser, toUser, hostId, delegatedDate, true, DateTime.now(), byUserId);
    }

    public HostDelegationTakeoutRecord toTakeoutRecord(String toUserLogin, String canceledByUserLogin) {
        return new HostDelegationTakeoutRecord(delegatedDate, toUserLogin, hostId, cancelled, cancelledDate, canceledByUserLogin);
    }
}
