package ru.yandex.webmaster3.storage.delegation;

import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author leonidrom
 *
 * Для takeout выгрузки используем логины вместо uid'ов
 */
public class HostDelegationTakeoutRecord extends AnonymousHostDelegationRecord {
    private final String toUser;
    private final String cancelledByUser;

    public HostDelegationTakeoutRecord(DateTime delegatedDate, String toUser, WebmasterHostId hostId,
                                       boolean cancelled, DateTime cancelledDate, @Nullable String cancelledByUser) {
        super(delegatedDate, hostId, cancelled, cancelledDate);
        this.toUser = toUser;
        this.cancelledByUser = cancelledByUser;
    }

    public DateTime getDelegatedDate() {
        return delegatedDate;
    }

    public String getToUser() {
        return toUser;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    public DateTime getCancelledDate() {
        return cancelledDate;
    }

    public String getCancelledByUser() {
        return cancelledByUser;
    }
}
