package ru.yandex.webmaster3.storage.delegation;

import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * @author avhaliullin
 * <p>
 * Лимиты на делегирование прав для хостов
 */
@Repository
public class UserDailyDelegationsYDao extends AbstractYDao {
    public UserDailyDelegationsYDao() {
        super(PREFIX_DELEGATION, "user_daily_delegations");
    }

    public void addDelegation(long userId) {
        insert(
                F.USER_ID.value(userId),
                F.ADD_DATE.value(DateTime.now())
        ).execute();
    }

    public void deleteForUser(WebmasterUser user) {
        delete()
                .where(F.USER_ID.eq(user.getUserId()))
                .execute();
    }

    public long countDelegations(long userId) {
        DateTime statisticPeriod = DateTime.now().minusDays(1);
        return select(DataMapper.SINGLE_COLUMN_INT_MAPPER).countAll()
                .where(F.USER_ID.eq(userId))
                .and(F.ADD_DATE.gt(statisticPeriod))
                .queryOne();
    }

    private static class F {
        static final Field<Long> USER_ID = Fields.longField("user_id");
        static final Field<DateTime> ADD_DATE = Fields.jodaDateTimeField("add_date");
    }
}
