package ru.yandex.webmaster3.storage.digest;

import NWebmaster.proto.digest.Digest;
import lombok.Getter;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;

/**
 * @author avhaliullin
 */
@Getter
public class DigestMessage {
    private final long userId;
    private final WebmasterHostId hostId;
    private final String email;
    private final LanguageEnum language;
    private final NotificationType notificationType;
    private final Digest.DigestWeeklyReportMessage digest;
    private final LocalDate digestPeriodEnd;

    public DigestMessage(long userId, WebmasterHostId hostId, String email, LanguageEnum language, NotificationType notificationType, Digest.DigestWeeklyReportMessage digest, LocalDate digestPeriodEnd) {
        this.userId = userId;
        this.hostId = hostId;
        this.email = email;
        this.language = language;
        this.notificationType = notificationType;
        this.digest = digest;
        this.digestPeriodEnd = digestPeriodEnd;
    }
}
