package ru.yandex.webmaster3.storage.digest;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ru.yandex.webmaster3.storage.util.clickhouse2.AbstractClickhouseDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHPrimitiveType;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHTable;

/**
 * @author avhaliullin
 */
public class DigestTableUtil {
    public static final String DATABASE = AbstractClickhouseDao.DB_WEBMASTER3_NOTIFICATIONS;
    public static final String TABLE_NAME_PREFIX = "digest_notification_";
    private static final DateTimeFormatter TABLE_NAME_DATE_FORMAT = DateTimeFormat.forPattern("yyyyMMdd");

    public static final CHTable TABLE_SPEC = CHTable.builder()
            .database(DATABASE)
            .name(TABLE_NAME_PREFIX + "%s")
            .partitionBy("toYYYYMM(date)")
            .keyField("date", CHPrimitiveType.Date)
            .keyField(F.USER_ID, CHPrimitiveType.Int64)
            .keyField(F.HOST_ID, CHPrimitiveType.String)
            .keyField(F.EMAIL, CHPrimitiveType.String)
            .keyField(F.LANG, CHPrimitiveType.String)
            .keyField(F.NOTIFICATION_TYPE, CHPrimitiveType.String)
            .field(F.DATA, CHPrimitiveType.String)
            .sharded(false)
            .build();

    public static class F {
        public static final String USER_ID = "user_id";
        public static final String HOST_ID = "host_id";
        public static final String EMAIL = "email";
        public static final String LANG = "lang";
        public static final String NOTIFICATION_TYPE = "notification_type";
        public static final String DATA = "data";
    }

    public static String tableDateString(LocalDate date) {
        return date.toString(TABLE_NAME_DATE_FORMAT);
    }

    public static String tableName(LocalDate date) {
        return TABLE_SPEC.replicatedMergeTreeTableName(0, tableDateString(date));
    }
}
