package ru.yandex.webmaster3.storage.download;

import lombok.Value;

/**
 * Created by ifilippov5 on 08.02.17.
 */
@Value
public class DownloadInfo {
    DownloadStatus downloadStatus;
    String publicUrlMds;
    String fileName;

    public static DownloadInfo inProgress() {
        return new DownloadInfo(DownloadStatus.IN_PROGRESS, null, null);
    }

    public static DownloadInfo success(String fileName, String url) {
        return new DownloadInfo(DownloadStatus.DONE, url, fileName);
    }

    public static DownloadInfo error() {
        return new DownloadInfo(DownloadStatus.INTERNAL_ERROR, null, null);
    }
}
