package ru.yandex.webmaster3.storage.download;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by ifilippov5 on 08.02.17.
 */
public enum DownloadStatus implements IntEnum {
    @Description("загружено")
    DONE(0),
    @Description("в процессе загрузки")
    IN_PROGRESS(1),
    @Description("не удалось загрузить из-за внутренней ошибки")
    INTERNAL_ERROR(2),;
    public static final IntEnumResolver<DownloadStatus> R = IntEnumResolver.r(DownloadStatus.class);
    private final int value;


    DownloadStatus(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }
}
