package ru.yandex.webmaster3.storage.download;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

import java.util.UUID;

/**
 * Created by ifilippov5 on 14.02.17.
 */
public abstract class DownloadTaskData<T> extends WorkerTaskData {
    private final Long nodeId;
    private final FileFormat exportFormat;
    private final String fileName;
    private final Long hash;
    private final Class<T> type;

    public DownloadTaskData(UUID taskId, WebmasterHostId hostId, Long nodeId, FileFormat exportFormat, String fileName, Long hash, Class<T> type) {
        super(taskId, hostId, WorkerTaskPriority.HIGH);
        this.nodeId = nodeId;
        this.exportFormat = exportFormat;
        this.fileName = fileName;
        this.hash = hash;
        this.type = type;
    }

    public DownloadTaskData(WebmasterHostId hostId, Long nodeId, FileFormat exportFormat, String fileName, Long hash, Class<T> type) {
        super(hostId, WorkerTaskPriority.HIGH);
        this.nodeId = nodeId;
        this.exportFormat = exportFormat;
        this.fileName = fileName;
        this.hash = hash;
        this.type = type;
    }

    public Long getNodeId() {
        return nodeId;
    }

    public FileFormat getExportFormat() {
        return exportFormat;
    }

    public String getFileName() {
        return fileName;
    }

    public Long getHash() {
        return hash;
    }

    public Class<T> getType() {
        return type;
    }
    
    public abstract WorkerTaskType getTaskType();

    public abstract String getShortDescription();
}
