package ru.yandex.webmaster3.storage.download.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Getter;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.links.BrokenLinkType;

/**
 * @author leonidrom
 */
@Getter
public class BrokenLinkSamplesMdsExportDescriptor extends MdsExportDescriptor{
    private final WebmasterHostId hostId;
    private final BrokenLinkType linkType;

    @JsonCreator
    public BrokenLinkSamplesMdsExportDescriptor(WebmasterHostId hostId, BrokenLinkType linkType) {
        super(DownloadFileType.BROKEN_LINKS);
        this.hostId = hostId;
        this.linkType = linkType;
    }
}
