package ru.yandex.webmaster3.storage.download.common;

import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;
import ru.yandex.webmaster3.storage.feeds.download.FeedsAllErrorsMdsExportDescriptor;
import ru.yandex.webmaster3.storage.feeds.download.FeedsClickStatisticsMdsExportDescriptor;
import ru.yandex.webmaster3.storage.feeds.download.FeedsEnrichedShowsMdsExportDescriptor;
import ru.yandex.webmaster3.storage.feeds.download.FeedsErrorsMdsExportDescriptor;
import ru.yandex.webmaster3.storage.feeds.download.FeedsNotEnrichableShowsMdsExportDescriptor;
import ru.yandex.webmaster3.storage.feeds.download.FeedsOfferBansDescriptor;
import ru.yandex.webmaster3.storage.hoststat.download.ContentAttrSamplesMdsExportDescriptor;
import ru.yandex.webmaster3.storage.niche.download.NicheQueriesMdsExportDescriptor;

/**
 * @author avhaliullin
 */
public enum DownloadFileType implements Discriminator<MdsExportDescriptor> {
    MEMORANDUM_URLS(MemorandumUrlsMdsExportDescriptor.class),
    METRIKA_CRAWL_SAMPLES(MetrikaCrawlSamplesMdsExportDescriptor.class),
    TURBO_SEARCH_URL_SAMPLES(TurboSearchUrlSamplesMdsExportDescriptor.class),
    LINKS(LinkMdsExportDescriptor.class),
    USER_URLS(UserUrlsMdsExportDescriptor.class),
    TURBO_TOP_PAGES_WITHOUT_TURBO(TurboTopPagesWithoutTurboMdsExportDescriptor.class),
    TURBO_AUTO_DELETED_PAGES(TurboAutoDeletedPagesMdsExportDescriptor.class),
    CONTENT_ATTR_SAMPLES(ContentAttrSamplesMdsExportDescriptor.class),
    NICHE_QUERIES(NicheQueriesMdsExportDescriptor.class),
    BROKEN_LINKS(BrokenLinkSamplesMdsExportDescriptor.class),
    FEEDS_VALIDATION_ERRORS(FeedsErrorsMdsExportDescriptor.FeedsValidationErrorsMdsExportDescriptor.class),
    FEEDS_QUALITY_ERRORS(FeedsErrorsMdsExportDescriptor.FeedsQualityErrorsMdsExportDescriptor.class),
    FEEDS_DOMAIN_ERRORS(FeedsErrorsMdsExportDescriptor.FeedsDomainErrorsMdsExportDescriptor.class),
    FEEDS_ALL_ERRORS(FeedsAllErrorsMdsExportDescriptor.class),
    FEEDS_OFFER_BAN(FeedsOfferBansDescriptor.class),
    FEEDS_SET_CLICK_STATISTICS(FeedsClickStatisticsMdsExportDescriptor.FeedsSetClickStatisticsMdsExportDescriptor.class),
    FEEDS_OFFER_CLICK_STATISTICS(FeedsClickStatisticsMdsExportDescriptor.FeedsOfferClickStatisticsMdsExportDescriptor.class),
    FEEDS_ENRICHED_SHOWS(FeedsEnrichedShowsMdsExportDescriptor.class),
    FEEDS_NOT_ENRICHABLE_SHOWS(FeedsNotEnrichableShowsMdsExportDescriptor.class),
    ;
    private final Class<? extends MdsExportDescriptor> dataClass;

    DownloadFileType(Class<? extends MdsExportDescriptor> dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public Class<? extends MdsExportDescriptor> getDataClass() {
        return dataClass;
    }
}
