package ru.yandex.webmaster3.storage.download.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

@Getter
public class LinkMdsExportDescriptor extends MdsExportDescriptor {
    private String host;
    private LinkType linkType;

    @JsonCreator
    public LinkMdsExportDescriptor(@JsonProperty("host") String host,@JsonProperty("linkType")  LinkType linkType) {
        super(DownloadFileType.LINKS);
        this.host = host;
        this.linkType = linkType;
    }

    public boolean isExternal() {
        return linkType == LinkType.EXTERNAL;
    }
}
