package ru.yandex.webmaster3.storage.download.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class MdsExportTaskData extends WorkerTaskData {
    private final FileFormat exportFormat;
    private final String fileName;
    private final Long hash;
    private final MdsExportDescriptor descriptor;

    @JsonCreator
    public MdsExportTaskData(@JsonProperty("taskId") UUID taskId,
                             @JsonProperty("hostId") WebmasterHostId hostId,
                             @JsonProperty("exportFormat") FileFormat exportFormat,
                             @JsonProperty("fileName") String fileName,
                             @JsonProperty("hash") Long hash,
                             @JsonProperty("descriptor") MdsExportDescriptor descriptor) {
        super(taskId, hostId, WorkerTaskPriority.HIGH);
        this.exportFormat = exportFormat;
        this.fileName = fileName;
        this.hash = hash;
        this.descriptor = descriptor;
    }

    public MdsExportTaskData(WebmasterHostId hostId, FileFormat exportFormat, String fileName, Long hash,
                             MdsExportDescriptor descriptor) {
        super(hostId, WorkerTaskPriority.HIGH);
        this.exportFormat = exportFormat;
        this.fileName = fileName;
        this.hash = hash;
        this.descriptor = descriptor;
    }

    public FileFormat getExportFormat() {
        return exportFormat;
    }

    public String getFileName() {
        return fileName;
    }

    public Long getHash() {
        return hash;
    }

    public MdsExportDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.MDS_EXPORT_TASK;
    }

    @Override
    public String getShortDescription() {
        return null;
    }
}
