package ru.yandex.webmaster3.storage.download.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.storage.searchurl.MemorandumFilter;

import java.util.List;

/**
 * @author avhaliullin
 */
public class MemorandumUrlsMdsExportDescriptor extends MdsExportDescriptor {
    private final Long nodeId;
    private final List<MemorandumFilter> filters;

    @JsonCreator
    public MemorandumUrlsMdsExportDescriptor(Long nodeId, List<MemorandumFilter> filters) {
        super(DownloadFileType.MEMORANDUM_URLS);
        this.nodeId = nodeId;
        this.filters = filters;
    }

    public Long getNodeId() {
        return nodeId;
    }

    public List<MemorandumFilter> getFilters() {
        return filters;
    }
}
