package ru.yandex.webmaster3.storage.download.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaCrawlSampleFilter;

import java.util.List;

/**
 * @author leonidrom
 */
public class MetrikaCrawlSamplesMdsExportDescriptor extends MdsExportDescriptor {
    private final String domain;
    private final long counterId;
    private final List<MetrikaCrawlSampleFilter> filters;

    @JsonCreator
    public MetrikaCrawlSamplesMdsExportDescriptor(String domain, long counterId, List<MetrikaCrawlSampleFilter> filters) {
        super(DownloadFileType.METRIKA_CRAWL_SAMPLES);
        this.domain = domain;
        this.counterId = counterId;
        this.filters = filters;
    }

    public String getDomain() {
        return domain;
    }

    public long getCounterId() {
        return counterId;
    }

    public List<MetrikaCrawlSampleFilter> getFilters() {
        return filters;
    }
}
