package ru.yandex.webmaster3.storage.download.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.turbo.model.TurboType;

public class TurboSearchUrlSamplesMdsExportDescriptor extends MdsExportDescriptor {
    private String domain;
    private long userId;
    private TurboType turboType;

    @JsonCreator
    public TurboSearchUrlSamplesMdsExportDescriptor(
        @JsonProperty("domain") String domain,
        @JsonProperty("userId") long userId,
        @JsonProperty("turboType") TurboType turboType
    ) {
        super(DownloadFileType.TURBO_SEARCH_URL_SAMPLES);
        this.domain = domain;
        this.userId = userId;
        this.turboType = turboType;
    }

    public String getDomain() {
        return domain;
    }

    public long getUserId() {
        return userId;
    }

    public TurboType getTurboType() {
        return turboType;
    }
}
