package ru.yandex.webmaster3.storage.download.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

/**
 * @author lester
 */
@Getter
public class UserUrlsMdsExportDescriptor extends MdsExportDescriptor {
    private String host;
    private UserUrlsType userUrlsType;

    @JsonCreator
    public UserUrlsMdsExportDescriptor(@JsonProperty("host") String host, @JsonProperty("userUrlsType") UserUrlsType userUrlsType) {
        super(DownloadFileType.USER_URLS);
        this.host = host;
        this.userUrlsType = userUrlsType;
    }

    public UserUrlsType getUserUrlsType() {
        return userUrlsType;
    }
}
