package ru.yandex.webmaster3.storage.download.searchquery;

import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

import java.util.UUID;

/**
 * Created by ifilippov5 on 03.03.17.
 */
public abstract class AbstractDownloadQueryStatisticTaskData extends WorkerTaskData {
    private final FileFormat exportFormat;
    private final String fileName;
    private final Long hash;
    private final LocalDate localDateFrom;
    private final LocalDate localDateTo;
    private final Integer[] regionId;
    private final RegionInclusion regionInclusion;
    private DeviceType deviceType;

    protected AbstractDownloadQueryStatisticTaskData(UUID taskId, WebmasterHostId hostId, LocalDate localDateFrom, LocalDate localDateTo, Integer[] regionId, RegionInclusion regionInclusion, DeviceType deviceType, FileFormat exportFormat, String fileName, Long hash) {
        super(taskId, hostId);
        this.deviceType = deviceType;
        this.exportFormat = exportFormat;
        this.fileName = fileName;
        this.hash = hash;
        this.localDateFrom = localDateFrom;
        this.localDateTo = localDateTo;
        this.regionId = regionId;
        this.regionInclusion = regionInclusion;
    }

    protected AbstractDownloadQueryStatisticTaskData(WebmasterHostId hostId, LocalDate localDateFrom, LocalDate localDateTo, Integer[] regionId, RegionInclusion regionInclusion, DeviceType deviceType, FileFormat exportFormat, String fileName, Long hash) {
        super(hostId);
        this.deviceType = deviceType;
        this.exportFormat = exportFormat;
        this.fileName = fileName;
        this.hash = hash;
        this.localDateFrom = localDateFrom;
        this.localDateTo = localDateTo;
        this.regionId = regionId;
        this.regionInclusion = regionInclusion;
    }

    public LocalDate getLocalDateFrom() {
        return localDateFrom;
    }

    public LocalDate getLocalDateTo() {
        return localDateTo;
    }

    public Integer[] getRegionId() {
        return regionId;
    }

    public RegionInclusion getRegionInclusion() {
        return regionInclusion;
    }

    public DeviceType getDeviceType() {
        return deviceType;
    }

    public FileFormat getExportFormat() {
        return exportFormat;
    }

    public String getFileName() {
        return fileName;
    }

    public Long getHash() {
        return hash;
    }

    public abstract WorkerTaskType getTaskType();

    public abstract String getShortDescription();
}
