package ru.yandex.webmaster3.storage.download.searchquery;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

import java.util.UUID;

/**
 * Created by ifilippov5 on 03.03.17.
 */
public class DownloadGroupStatisticTaskData extends AbstractDownloadQueryStatisticTaskData {

    private final QueryIndicator orderByInd;
    private final OrderDirection orderDirectionInd;

    public DownloadGroupStatisticTaskData(@JsonProperty("taskId") UUID taskId,
                                          @JsonProperty("hostId") WebmasterHostId hostId,
                                          @JsonProperty("localDateFrom") LocalDate localDateFrom,
                                          @JsonProperty("localDateTo") LocalDate localDateTo,
                                          @JsonProperty("regionId") Integer[] regionId,
                                          @JsonProperty("regionInclusion") RegionInclusion regionInclusion,
                                          @JsonProperty("deviceType") DeviceType deviceType,
                                          @JsonProperty("orderByInd") QueryIndicator orderByInd,
                                          @JsonProperty("orderDirectionInd") OrderDirection orderDirectionInd,
                                          @JsonProperty("exportFormat") FileFormat exportFormat,
                                          @JsonProperty("fileName") String fileName,
                                          @JsonProperty("hash") Long hash) {
        super(taskId, hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.orderByInd = orderByInd;
        this.orderDirectionInd = orderDirectionInd;
    }

    public DownloadGroupStatisticTaskData(WebmasterHostId hostId,
                                          LocalDate localDateFrom,
                                          LocalDate localDateTo,
                                          Integer[] regionId,
                                          RegionInclusion regionInclusion,
                                          DeviceType deviceType,
                                          QueryIndicator orderByInd,
                                          OrderDirection orderDirectionInd,
                                          FileFormat exportFormat,
                                          String fileName,
                                          Long hash) {
        super(hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.orderByInd = orderByInd;
        this.orderDirectionInd = orderDirectionInd;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId,
                                                LocalDate localDateFrom,
                                                LocalDate localDateTo,
                                                Integer[] regionId,
                                                RegionInclusion regionInclusion,
                                                DeviceType deviceType,
                                                QueryIndicator orderByInd,
                                                OrderDirection orderDirectionInd,
                                                FileFormat exportFormat,
                                                String fileName,
                                                Long hash) {
        return new DownloadGroupStatisticTaskData(hostId,
                localDateFrom,
                localDateTo,
                regionId,
                regionInclusion,
                deviceType,
                orderByInd,
                orderDirectionInd,
                exportFormat,
                fileName,
                hash);
    }

    public QueryIndicator getOrderByInd() {
        return orderByInd;
    }

    public OrderDirection getOrderDirectionInd() {
        return orderDirectionInd;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_STATISTIC_ALL_GROUPS_ALL_INDICATORS;
    }

    @Override
    public String getShortDescription() {
        return "Download all groups all indicators";
    }
}
