package ru.yandex.webmaster3.storage.download.searchquery;

import com.datastax.driver.core.utils.UUIDs;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;

import java.util.UUID;

/**
 * Created by Oleg Bazdyrev on 13/11/2017.
 */
public class DownloadRivalsStatisticsTaskData extends AbstractDownloadQueryStatisticTaskData {

    private final AggregatePeriod period;
    private final String thematics;

    @JsonCreator
    public DownloadRivalsStatisticsTaskData(UUID taskId, WebmasterHostId hostId, LocalDate localDateFrom,
                                            LocalDate localDateTo, DeviceType deviceType, FileFormat exportFormat,
                                            String fileName, Long hash, AggregatePeriod period, String thematics) {
        super(taskId, hostId, localDateFrom, localDateTo, null, null, deviceType, exportFormat, fileName, hash);
        this.period = period;
        this.thematics = thematics;
    }

    public DownloadRivalsStatisticsTaskData(WebmasterHostId hostId, LocalDate localDateFrom, LocalDate localDateTo,
                                            DeviceType deviceType, FileFormat exportFormat, String fileName, Long hash,
                                            AggregatePeriod period, String thematics) {
        this(UUIDs.timeBased(), hostId, localDateFrom, localDateTo, deviceType, exportFormat, fileName, hash, period, thematics);
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    public String getThematics() {
        return thematics;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_RIVALS_STATISTICS;
    }

    @Override
    public String getShortDescription() {
        return "Rivals stats download";
    }
}
